;======================================================================
;======================================================================
; -2 states file for "Kanna"
;======================================================================
;======================================================================

[Statedef -2]

;----------------------------------------------------------------------
; HitSounds and HitEffects
;----------------------------------------------------------------------

;----------------------------------------------------------------------
; MoveContact detection

[State -2, MoveHitReset]
type = MoveHitReset
triggerall = MoveContact
triggerall = var(2) = 1
trigger1 = (StateNo = [120,420])
trigger2 = (StateNo = [1000,7999])
ignorehitpause = 1

[State -2, VarSet];MoveHit Detection
type = VarSet
trigger1 = MoveHit
var(1) = 1
ignorehitpause = 1

[State -2, VarSet];MoveGuarded Detection
type = VarSet
trigger1 = MoveGuarded
var(1) = 2
ignorehitpause = 1

[State -3, VarSet];MoveReversed Detection
type = VarSet
triggerall = NumEnemy != 0
trigger1 = EnemyNear,AuthorName = "586" && (EnemyNear,StateNo = [120,155]) && MoveReversed
trigger2 = EnemyNear,AuthorName = "586" && (EnemyNear,StateNo = [120,155]) && MoveHit
var(1) = 3
ignorehitpause = 1

[State -2, VarSet];MoveContact Detection
type = VarSet
trigger1 = MoveContact
var(2) = 2
ignorehitpause = 1

[State -2, VarSet];HitFlag Reset
type = VarSet
trigger1 = MoveType != A
var(1) = 0
ignorehitpause = 1

[State -2, VarSet];MoveContact Initialize
type = VarAdd
trigger1 = var(2) > 0
var(2) = -1
ignorehitpause = 1

[State -2, VarAdd];HitCounter Addition
type = VarAdd
trigger1 = NumProjID(39999) > 0
var(9) = NumProjID(39999)
ignorehitpause = 1

[State -2, VarAdd];HitCounter Addition
type = VarAdd
trigger1 = NumProjID(31500) > 0
var(9) = NumProjID(31500)
ignorehitpause = 1

;----------------------------------------------------------------------
; HitEffects Helper

[State -2, HitEffects]
type = Helper
trigger1 = MoveHit
trigger1 = var(0) = 1
helpertype = normal
name = "HitSpark"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30000
ID = 30000
ignorehitpause = 1

[State -2, HitEffects]
type = Helper
trigger1 = MoveHit
trigger1 = var(0) = 2
helpertype = normal
name = "HitSpark"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30000
ID = 30001
ignorehitpause = 1

[State -2, HitEffects]
type = Helper
trigger1 = MoveHit
trigger1 = var(0) = 3
helpertype = normal
name = "HitSpark"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30000
ID = 30002
ignorehitpause = 1

[State -2, HitEffects]
type = Helper
trigger1 = MoveHit
trigger1 = var(0) = 4
helpertype = normal
name = "HitSpark"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30000
ID = 30003
ignorehitpause = 1

[State -2, HitEffects]
type = Helper
trigger1 = MoveHit
trigger1 = var(0) = 5
helpertype = normal
name = "HitSpark"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30000
ID = 30004
ignorehitpause = 1

[State -2, HitEffects]
type = Helper
trigger1 = MoveHit
trigger1 = var(0) = 6
helpertype = normal
name = "HitSpark"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30000
ID = 30005
ignorehitpause = 1

[State -2, HitEffects]
type = Helper
trigger1 = MoveHit
trigger1 = var(0) = 7
helpertype = normal
name = "HitSpark"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30000
ID = 30006
ignorehitpause = 1

[State -2, HitEffects]
type = Helper
trigger1 = MoveHit
trigger1 = var(0) = 8
helpertype = normal
name = "HitSpark"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30000
ID = 30007
ignorehitpause = 1

;----------------------------------------------------------------------
; GuardEffects Helper

[State -2, HitEffects]
type = Helper
trigger1 = MoveGuarded
trigger1 = var(0) != 0
helpertype = normal
name = "GuardSpark"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30000
ID = 30100
ignorehitpause = 1

;----------------------------------------------------------------------
; HitSounds / GuardSounds - for Player

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumHelper(30000) > 0
value = s1,0
channel = 2
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumHelper(30001) > 0
value = s1,1
channel = 2
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumHelper(30002) > 0
value = s1,2
channel = 2
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumHelper(30003) > 0
value = s1,4
channel = 2
ignorehitpause = 1

[State -2, HitSounds]	;Double
type = PlaySnd
trigger1 = NumHelper(30004) > 0
value = s1,2
channel = 2
ignorehitpause = 1

[State -2, HitSounds]	;Double
type = PlaySnd
trigger1 = NumHelper(30004) > 0
value = s1,5
channel = 5
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumHelper(30005) > 0
value = s1,3
channel = 5
ignorehitpause = 1

[State -2, HitSounds]	;Double
type = PlaySnd
trigger1 = NumHelper(30006) > 0
value = s1,2
channel = 2
ignorehitpause = 1

[State -2, HitSounds]	;Double
type = PlaySnd
trigger1 = NumHelper(30006) > 0
value = s1,9
channel = 5
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumHelper(30007) > 0
value = s1,6
channel = 2
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumHelper(30100) > 0
value = s1,7
channel = 2
ignorehitpause = 1

;----------------------------------------------------------------------
; HitSounds / GuardSounds - for Helper

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumProjID(31000) > 0
value = s1,0
channel = 2
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumProjID(31001) > 0
value = s1,1
channel = 2
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumProjID(31002) > 0
value = s1,2
channel = 2
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumProjID(31003) > 0
value = s1,4
channel = 2
ignorehitpause = 1

[State -2, HitSounds]	;Double
type = PlaySnd
trigger1 = NumProjID(31004) > 0
value = s1,2
channel = 2
ignorehitpause = 1

[State -2, HitSounds]	;Double
type = PlaySnd
trigger1 = NumProjID(31004) > 0
value = s1,5
channel = 5
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumProjID(31005) > 0
value = s1,3
channel = 2
ignorehitpause = 1

[State -2, HitSounds]	;Double
type = PlaySnd
trigger1 = NumProjID(31006) > 0
value = s1,2
channel = 2
ignorehitpause = 1

[State -2, HitSounds]	;Double
type = PlaySnd
trigger1 = NumProjID(31006) > 0
value = s1,9
channel = 5
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumProjID(31007) > 0
value = s1,6
channel = 2
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumProjID(31100) > 0
value = s1,7
channel = 2
ignorehitpause = 1

;----------------------------------------------------------------------
; Other Sounds

[State -2, PlaySnd];Wire Damage
type = PlaySnd
triggerall = P2MoveType = H
trigger1 = P2StateNo = 45002
value = s2,5
supermovetime = 0
pausemovetime = 0

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumProjID(30201) > 0
value = s1,10
channel = 5
ignorehitpause = 1

[State -2, HitSounds]
type = PlaySnd
trigger1 = NumProjID(30202) > 0
value = s3,8
channel = 3
ignorehitpause = 1

;----------------------------------------------------------------------
; Just Defence
;----------------------------------------------------------------------

[State -2, VarSet]
type = VarSet
trigger1 = StateNo != 145
var(14) = 0
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = StateNo != 125 && StateNo != 140 && StateNo != 145
var(18) = 0
ignorehitpause = 1

[State -2, ChnageState]
type = ChangeState
trigger1 = var(19) = 1
value = 125
ignorehitpause = 1

[State -2, Helper]
type = Helper
trigger1 = NumHelper(10120) = 0
helpertype = normal
name = "Recoil"
postype = p1
pos = 0,0
pausemovetime = 999999
supermovetime = 999999
stateno = 10120
ID = 10120
ignorehitpause = 1

[State -2, NotHitBy]
type = NotHitBy
trigger1 = NumHelper(10120) = 1
trigger1 = (Helper(10120),StateNo = [10121,10123]) && (Helper(10120),Anim != 99990)
value = ,AP
time = 1

[State -2, HitOverRide]
type = HitOverRide
trigger1 = NumHelper(10120) = 1
trigger1 = (Helper(10120),StateNo = [10121,10123]) && (Helper(10120),Anim != 99990)
trigger1 = var(1) = 3
attr = SCA, AA, AP
slot = 0
stateno = 125
time = 1
ignorehitpause = 1

;----------------------------------------------------------------------
; Movement in the air
;----------------------------------------------------------------------

;----------------------------------------------------------------------
; Air Jump / Air Dash

[State -2, VarSet];Air Jump flag initialize
type = VarSet
trigger1 = StateType != A || StateNo = 5210
var(5) = 0

[State -2, VarSet];Air Dash flag initialize
type = VarSet
trigger1 = StateType != A || StateNo = 5210
var(6) = 0

[State -2, VarSet];Holdup detector
type = VarAdd
trigger1 = command = "holdup"
var(7) = 1

[State -2, VarSet];Holdup flag initialize
type = VarSet
trigger1 = command != "holdup"
var(7) = 0

[State -2, VarSet]
type = VarAdd
trigger1 = var(8) > 0
var(8) = -1
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = StateType != A
var(8) = 0

[State -2, VarSet]
type = VarSet
trigger1 = StateType != A
trigger2 = (StateNo = [110,115]) && Time = 1
var(27) = 0

[State -2, VarSet];Early Input
type = VarSet
trigger1 = command = "FF_2"
var(27) = 1
ignorehitpause = 1

[State -2, VarSet];Early Input
type = VarSet
trigger1 = command = "BB_2"
var(27) = 2
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = StateNo = [41,44]
trigger2 = StateNo = [60,79]
trigger3 = StateNo = [100,115]
trigger4 = StateType != A
var(10) = 0

;----------------------------------------------------------------------
; Effect

[State -2, AfterImage]
type = AfterImage
trigger1 = MoveType = H
time = 0

;----------------------------------------------------------------------
; Ice Damage
;----------------------------------------------------------------------

;----------------------------------------------------------------------
; Ice Damage - P1/P2/Fall

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 1
triggerall = NumHelper(30600) = 0
triggerall = var(20) = 1
trigger1 = Enemy(0),StateNo = 45040
helpertype = normal
name = "Ice"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30600
ID = 30600
ignorehitpause = 1

;----------------------------------------------------------------------
; Ice Damage - P1/P4/Fall

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 2
triggerall = NumHelper(30601) = 0
triggerall = var(20) = 1
trigger1 = Enemy(1),StateNo = 45040
helpertype = normal
name = "Ice"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30600
ID = 30601
ignorehitpause = 1

;----------------------------------------------------------------------
; Ice Damage - P3/P2/Fall

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 1
triggerall = NumHelper(30610) = 0
triggerall = var(20) = 2
trigger1 = Enemy(0),StateNo = 45045
helpertype = normal
name = "Ice"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30600
ID = 30610
ignorehitpause = 1

;----------------------------------------------------------------------
; Ice Damage - P3/P4/Fall

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 2
triggerall = NumHelper(30611) = 0
triggerall = var(20) = 2
trigger1 = Enemy(1),StateNo = 45045
helpertype = normal
name = "Ice"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30600
ID = 30611
ignorehitpause = 1

;----------------------------------------------------------------------
; Ice Damage - P1/P2/Ground

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 1
triggerall = NumHelper(30700) = 0
triggerall = var(20) = 1
trigger1 = Enemy(0),StateNo = 45050
helpertype = normal
name = "Ice"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30700
ID = 30700
ignorehitpause = 1

;----------------------------------------------------------------------
; Ice Damage - P1/P4/Ground

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 2
triggerall = NumHelper(30701) = 0
triggerall = var(20) = 1
trigger1 = Enemy(1),StateNo = 45050
helpertype = normal
name = "Ice"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30700
ID = 30701
ignorehitpause = 1

;----------------------------------------------------------------------
; Ice Damage - P3/P2/Ground

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 1
triggerall = NumHelper(30710) = 0
triggerall = var(20) = 2
trigger1 = Enemy(0),StateNo = 45055
helpertype = normal
name = "Ice"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30700
ID = 30710
ignorehitpause = 1

;----------------------------------------------------------------------
; Ice Damage - P3/P4/Ground

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 2
triggerall = NumHelper(30711) = 0
triggerall = var(20) = 2
trigger1 = Enemy(1),StateNo = 45055
helpertype = normal
name = "Ice"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30700
ID = 30711
ignorehitpause = 1

;----------------------------------------------------------------------
; Fire Damage
;----------------------------------------------------------------------

;----------------------------------------------------------------------
; Fire Damage - P1/P2/Fall

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 1
triggerall = var(20) = 1
trigger1 = Enemy(0),StateNo = 45010
helpertype = normal
name = "Fire"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30800
ID = 30800
ignorehitpause = 1

;----------------------------------------------------------------------
; Fire Damage - P1/P4/Fall

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 2
triggerall = var(20) = 1
trigger1 = Enemy(1),StateNo = 45010
helpertype = normal
name = "Fire"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30800
ID = 30801
ignorehitpause = 1

;----------------------------------------------------------------------
; Fire Damage - P3/P2/Fall

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 1
triggerall = var(20) = 2
trigger1 = Enemy(0),StateNo = 45020
helpertype = normal
name = "Fire"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30800
ID = 30810
ignorehitpause = 1

;----------------------------------------------------------------------
; Fire Damage - P3/P4/Fall

[State -2, HitEffects]
type = Helper
triggerall = NumEnemy >= 2
triggerall = var(20) = 2
trigger1 = Enemy(1),StateNo = 45020
helpertype = normal
name = "Fire"
postype = p1
pos = 0,0
pausemovetime = 9999
supermovetime = 9999
stateno = 30800
ID = 30811
ignorehitpause = 1

;----------------------------------------------------------------------
; HitFlag

[State -2, VarSet]
type = VarSet
trigger1 = (!EnemyNear,HitFall && (Enemy,TeamMode = Single || Enemy,TeamMode = Turns)) && (Enemy,StateNo != [45000,45004])
trigger2 = (EnemyNear,HitFall && !EnemyNear,CanRecover && (Enemy,TeamMode = Single || Enemy,TeamMode = Turns)) && (Enemy,StateNo != [45000,45004])
trigger3 = Enemy,TeamMode = Simul
trigger4 = (Enemy,StateNo = [45000,45004]) && (Enemy,sysvar(1) != 0) && (Enemy,MoveType = H)
var(4) = 1

[State -2, VarSet]
type = VarSet
triggerall = (Enemy,TeamMode = Simul) = 0
trigger1 = Enemy,StateNo != [45000,45004]
trigger1 = (!EnemyNear,HitFall && (Enemy,TeamMode = Single || Enemy,TeamMode = Turns)) = 0
trigger1 = (EnemyNear,HitFall && !EnemyNear,CanRecover && (Enemy,TeamMode = Single || Enemy,TeamMode = Turns)) = 0
trigger2 = (Enemy,StateNo = [45000,45004]) && (Enemy,sysvar(1) = 0) && (Enemy,MoveType = H)
var(4) = 0

;----------------------------------------------------------------------
; AttackMulSet

[State -2, VarSet]
type = VarSet
trigger1 = var(40)/10%10 = 0
fvar(0) = ifelse(fvar(2) > 1,1,fvar(2))*fvar(8)
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = var(40)/10%10 = 1
fvar(0) = ifelse(fvar(2) > 1,1,fvar(2))*fvar(8)*fvar(9)
ignorehitpause = 1

[State -2, VarAdd]
type = VarSet
triggerall = var(9) > 0
triggerall = fvar(18) = 0
trigger1 = MoveHit
trigger2 = NumProjID(30500) > 0
trigger3 = NumProjID(31500) > 0
fvar(2) = fvar(2)*((1.0-fvar(1))*ifelse(fvar(2)*(1.0-fvar(1)) > 1.0,(1.0-fvar(1)),1))
ignorehitpause = 1

[State -2, VarAdd]
type = VarSet
trigger1 = P2MoveType != H
fvar(2) = 1
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = MoveHit
trigger2 = NumProjID(31500) > 0
fvar(1) = fvar(3)
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = P2MoveType != H
fvar(1) = 0
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = 1
fvar(6) = fvar(4)*fvar(2)
ignorehitpause = 1

[State -2, VarSet];HitCount
type = VarSet
trigger1 = P2MoveType != H
var(9) = 0
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = MoveHit
fvar(18) = 0
ignorehitpause = 1

[State -2, VarSet]
type = Null;VarSet
trigger1 = fvar(16) != 3
fvar(8) = 1
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = fvar(16) != 3
fvar(8) = 1+fvar(15)*0.0005
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = fvar(16) = 3
fvar(8) = 1+fvar(15)/1000.0
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = MoveType = H
var(16) = 0
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = MoveType = H
var(17) = 0
ignorehitpause = 1

[State -2, VarAdd]		;Knock back
type = VarSet
trigger1 = var(9) > 20
trigger1 = P2StateType != A
fvar(17) = (1.0+((var(9)-20)*0.75))*(-1)
ignorehitpause = 1

[State -2, VarAdd]		;Knock back
type = VarSet
trigger1 = var(9) <= 20
trigger2 = P2StateType = A
fvar(17) = 0
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = 1
fvar(9) = ((Enemy,LifeMax/1000.0)-((Enemy,LifeMax-Enemy,Life)*0.0005)) / (Enemy,LifeMax/1000.0)
ignorehitpause = 1

;----------------------------------------------------------------------
; MoveHit Correction - for Helper

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30501) > 0
fvar(1) = 0.01
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30502) > 0
fvar(1) = 0.02
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30503) > 0
fvar(1) = 0.03
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30504) > 0
fvar(1) = 0.04
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30505) > 0
fvar(1) = 0.05
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30506) > 0
fvar(1) = 0.06
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30507) > 0
fvar(1) = 0.07
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30508) > 0
fvar(1) = 0.08
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30509) > 0
fvar(1) = 0.09
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30510) > 0
fvar(1) = 0.10
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30511) > 0
fvar(1) = 0.11
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30512) > 0
fvar(1) = 0.12
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30513) > 0
fvar(1) = 0.13
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30514) > 0
fvar(1) = 0.14
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30515) > 0
fvar(1) = 0.15
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30516) > 0
fvar(1) = 0.16
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30517) > 0
fvar(1) = 0.17
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30518) > 0
fvar(1) = 0.18
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30519) > 0
fvar(1) = 0.19
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30520) > 0
fvar(1) = 0.20
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30521) > 0
fvar(1) = 0.21
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30522) > 0
fvar(1) = 0.22
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30523) > 0
fvar(1) = 0.23
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30524) > 0
fvar(1) = 0.24
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30525) > 0
fvar(1) = 0.25
ignorehitpause = 1

[State -2, VarSet]
type = VarSet
trigger1 = NumProjID(30550) > 0
fvar(1) = 0.05
ignorehitpause = 1

;----------------------------------------------------------------------
; DefenceMulSet

[State -2, DefenceMulSet]
type = DefenceMulSet
trigger1 = var(40)%10 = 1
value = fvar(10)
ignorehitpause = 1

[State -2, VarSet];need more trigger.
type = VarSet
trigger1 = 1
fvar(10) = ((LifeMax/1000.0)-((LifeMax-Life)*0.0005)) / (LifeMax/1000.0)
ignorehitpause = 1

;----------------------------------------------------------------------
; Width

[State -3, Width]
type = Width
trigger1 = FrontEdgeDist < 8 && MoveType != H
edge = 3,

;----------------------------------------------------------------------
; Reinforce Gauge
;----------------------------------------------------------------------
;
; fvar(15)	- Value
; fvar(16)	- Reinforce Level(Blue(1)/Red(2)/White(3))
;

;----------------------------------------------------------------------
; Frame

[State -2, Explod];Gauge - Frame
type = Explod
trigger1 = NumExplod(10030) = 0
anim = 10030
ID = 10030
pos = ifelse(TeamSide = 1,25,295),3
postype = Left
bindtime = -1
removetime = -1
ownpal = 1
ontop = 0
sprpriority = -5
facing = ifelse(TeamSide = 1,1,-1)
pausemovetime = 999999
supermovetime = 999999
scale = 1,1
ignorehitpause = 1

;----------------------------------------------------------------------
; Gauge - Blue

[State -2, Explod];Gauge - Blue
type = Explod
trigger1 = NumExplod(10031) = 0
trigger1 = fvar(16) = [1,2]
anim = 10031
ID = 10031
pos = ifelse(TeamSide = 1,27,293),5
postype = Left
bindtime = -1
removetime = -1
ownpal = 1
ontop = 0
sprpriority = -4
facing = ifelse(TeamSide = 1,1,-1)
pausemovetime = 999999
supermovetime = 999999
scale = 1,1
ignorehitpause = 1

;----------------------------------------------------------------------
; Gauge - Red

[State -2, Explod];Gauge - Red
type = Explod
trigger1 = NumExplod(10032) = 0
trigger1 = fvar(16) = 2
anim = 10032
ID = 10032
pos = ifelse(TeamSide = 1,27,293),5
postype = Left
bindtime = -1
removetime = -1
ownpal = 1
ontop = 0
sprpriority = -3
facing = ifelse(TeamSide = 1,1,-1)
pausemovetime = 999999
supermovetime = 999999
scale = 1,1
ignorehitpause = 1

;----------------------------------------------------------------------
; Gauge - White

[State -2, Explod];Gauge - White
type = Explod
trigger1 = NumExplod(10033) = 0
trigger1 = fvar(16) = 3
anim = 10033
ID = 10033
pos = ifelse(TeamSide = 1,27,293),5
postype = Left
bindtime = -1
removetime = -1
ownpal = 1
ontop = 0
sprpriority = -3
facing = ifelse(TeamSide = 1,1,-1)
pausemovetime = 999999
supermovetime = 999999
scale = 1,1
ignorehitpause = 1

;----------------------------------------------------------------------
; ModifyExplod

[State -2, ModifyExplod]	;Frame
type = ModifyExplod
trigger1 = NumExplod(10030) = 1
ID = 10030
postype = Left
pos = ifelse(TeamSide = 1,25+var(23),295-var(23)),3+var(24)
ignorehitpause = 1

[State -2, ModifyExplod]	;Blue
type = ModifyExplod
trigger1 = NumExplod(10031) = 1
trigger1 = fvar(16) = [1,2]
ID = 10031
scale = ifelse(fvar(16) = 1,fvar(15)/100,ifelse(fvar(16) = 3,0,1)),1
postype = Left
pos = ifelse(TeamSide = 1,27+var(23),293-var(23)),5+var(24)
ignorehitpause = 1

[State -2, ModifyExplod]	;Red
type = ModifyExplod
trigger1 = NumExplod(10032) = 1
trigger1 = fvar(16) = 2
ID = 10032
scale = (fvar(15)-100)/100,1
postype = Left
pos = ifelse(TeamSide = 1,27+var(23),293-var(23)),5+var(24)
ignorehitpause = 1

[State -2, ModifyExplod]	;White
type = ModifyExplod
trigger1 = NumExplod(10033) = 1
trigger1 = fvar(16) = 3
ID = 10033
scale = (fvar(15))/100,1
postype = Left
pos = ifelse(TeamSide = 1,27+var(23),293-var(23)),5+var(24)
ignorehitpause = 1

;----------------------------------------------------------------------
; RemoveExplod

[State -2, RemoveExplod]	;Blue
type = RemoveExplod
trigger1 = fvar(16) = 3
ID = 10031
ignorehitpause = 1

[State -2, RemoveExplod]	;Red
type = RemoveExplod
trigger1 = fvar(16) = 3
trigger2 = fvar(15) < 100
ID = 10032
ignorehitpause = 1

[State -2, RemoveExplod]	;White
type = RemoveExplod
trigger1 = fvar(16) != 3
ID = 10033
ignorehitpause = 1

;----------------------------------------------------------------------
; VarAdd

[State -2, VarAdd]		;Blue
type = VarAdd
triggerall = RoundState = 2
triggerall = fvar(16) = 1
triggerall = fvar(15) < 100
trigger1 = MoveType != H
trigger2 = StateNo = [120,155]
fvar(15) = 0.167 + (0.04*(StateNo = [150,155]))
ignorehitpause = 1

[State -2, VarAdd]		;Red
type = VarAdd
triggerall = RoundState = 2
triggerall = fvar(16) = 2
triggerall = fvar(15) < 200
trigger1 = MoveType != H
trigger2 = StateNo = [120,155]
fvar(15) = 0.067 + (0.04*(StateNo = [150,155]))
ignorehitpause = 1

[State -2, VarAdd]		;White
type = VarAdd
triggerall = RoundState = 2
trigger1 = MoveType = H
trigger1 = StateNo != [120,155]
trigger1 = StateNo != [5110,5150]
trigger1 = fvar(16) = 3
trigger1 = GameTime % 4 = 0
trigger1 = fvar(15) >= 0
fvar(15) = -0.5
ignorehitpause = 1

[State -2, VarAdd]		;Blue Flag
type = VarSet
trigger1 = fvar(16) != 3
trigger1 = fvar(15) < 100
fvar(16) = 1
ignorehitpause = 1

[State -2, VarAdd]		;Red Flag
type = VarSet
trigger1 = fvar(16) != 3
trigger1 = fvar(15) = [100,199]
fvar(16) = 2
ignorehitpause = 1

[State -2, VarAdd]		;White Flag
type = VarSet
trigger1 = fvar(15) >= 200
fvar(16) = 3
ignorehitpause = 1

[State -2, VarAdd]		;White Flag
type = VarSet
trigger1 = fvar(15) >= 200
trigger1 = fvar(16) = 3
fvar(15) = 100
ignorehitpause = 1

[State -2, VarAdd]		;Reset Flag
type = VarSet
trigger1 = fvar(15) <= 0
fvar(16) = 1
ignorehitpause = 1

[State -2, VarAdd]		;Reset Flag
type = VarSet
trigger1 = fvar(15) < 0
fvar(15) = 0
ignorehitpause = 1

[State -2, VarAdd]		;Reset Flag
type = VarSet
trigger1 = var(40)/100%10 = 1
fvar(16) = 3
ignorehitpause = 1

[State -2, VarAdd]		;Reset Flag
type = VarSet
trigger1 = var(40)/100%10 = 1
fvar(15) = 100
ignorehitpause = 1

;----------------------------------------------------------------------
; Special Features
;----------------------------------------------------------------------

;----------------------------------------------------------------------
; Distinction P1 or P3

[State -2, VarAdd]
type = VarSet
trigger1 = !NumPartner
var(20) = 1
ignorehitpause = 1

[State -2, VarAdd]		;P1
type = VarSet
trigger1 = NumPartner
trigger1 = ID < Partner,ID
var(20) = 1
ignorehitpause = 1

[State -2, VarAdd]		;P3
type = VarSet
trigger1 = NumPartner
trigger1 = ID > Partner,ID
var(20) = 2
ignorehitpause = 1

;----------------------------------------------------------------------
; PlayerID

[State -2, VarAdd]
type = VarSet
trigger1 = NumEnemy >= 1
var(21) = Enemy(0),ID
ignorehitpause = 1

[State -2, VarAdd]
type = VarSet
trigger1 = NumEnemy >= 2
var(22) = Enemy(1),ID
ignorehitpause = 1

;----------------------------------------------------------------------
; Poison Damage for Arcana Heart Characters by Drowin

[State -2, PowerAdd]
type = PowerAdd
triggerall = Enemy,AuthorName = "Drowin arcana"
triggerall = Enemy,fvar(20) > 0
trigger1 = Power > 0
value = -1

[State -2, LifeAdd]
type = LifeAdd
triggerall = Enemy,AuthorName = "Drowin arcana"
triggerall = Enemy,fvar(20) > 0
trigger1 = GameTime % 7 = 0
value = -1
kill = 0

[State -2, PalFX]
type = PalFX
triggerall = Enemy,AuthorName = "Drowin arcana"
trigger1 = Enemy,fvar(20) > 0
add = 100,0,110
mul = 220,220,220
time = 5

;----------------------------------------------------------------------
; Fire Damage for Akiha Vermilion by 9

[State -2, LifeAdd]
type = LifeAdd
triggerAll = Enemy,AuthorName = "H" && Enemy,Name = "Akiha_Vermilion"
trigger1 = Enemy,var(47) = 1
value = -5
kill = 0

[State -2, PowerAdd]
type = PowerAdd
triggerAll = Enemy,AuthorName = "H" && Enemy,Name = "Akiha_Vermilion"
trigger1 = Enemy,var(47) = 1
value = -26

;----------------------------------------------------------------------
; Curse Damage for Misuzu Kamio

[State -2, LifeAdd]
type = LifeAdd
triggerall = (Enemy,TeamMode = Simul) = 0
triggerall = (TeamMode = Simul) = 0
triggerall = NumEnemy
triggerall = Enemy,AuthorName = "586"
triggerall = Enemy,Name = "Misuzu Kamio"
triggerall = Enemy,fvar(11) > 0
trigger1 = Enemy,var(13) = 1
trigger1 = GameTime % 13 = 0
trigger2 = Enemy,var(13) = 2
trigger2 = GameTime % 11 = 0
trigger3 = Enemy,var(13) = 3
trigger3 = GameTime % 8 = 0
trigger4 = Enemy,var(13) = 4
trigger4 = GameTime % 6 = 0
trigger5 = Enemy,var(13) = 5
trigger5 = GameTime % 3 = 0
value = -1
kill = 0
ignorehitpause = 1

[State -2, PalFX]
type = PalFX
triggerall = (Enemy,TeamMode = Simul) = 0
triggerall = (TeamMode = Simul) = 0
triggerall = NumEnemy
triggerall = Enemy,AuthorName = "586"
triggerall = Enemy,Name = "Misuzu Kamio"
trigger1 = Enemy,fvar(11) > 0
add = -50,150,150
time = 1
ignorehitpause = 1

;----------------------------------------------------------------------
; Personal Settings
;----------------------------------------------------------------------

;----------------------------------------------------------------------
; RemoveExplod

[State -2, RemoveExplod]
type = RemoveExplod
trigger1 = StateType = A
trigger2 = StateNo = [600,610]
ID = 2000
ignorehitpause = 1

[State -2, RemoveExplod]
type = RemoveExplod
trigger1 = StateType != A
trigger2 = StateNo = [600,610]
ID = 2400
ignorehitpause = 1

;----------------------------------------------------------------------
; Enemy Detector

[State -2, VarSet]
type = VarSet
trigger1 = P2Name = "Ayu Tukimiya" || P4Name = "Ayu Tukimiya"
var(15) = 1

;----------------------------------------------------------------------
; WinPose

[State -2, VarSet]
type = VarSet
triggerall = Win
triggerall = PlayerIDExist(var(21))
triggerall = NumEnemy > 0
trigger1 = Enemy,Stateno != 5150
var(25) = ceil(PlayerID(var(21)),ScreenPos X - ScreenPos X)*Facing

[State -2, VarSet]
type = VarSet
triggerall = Win
triggerall = PlayerIDExist(var(22))
triggerall = NumEnemy > 1
trigger1 = Enemy,Stateno != 5150
var(26) = ceil(PlayerID(var(22)),ScreenPos X - ScreenPos X)*Facing

;----------------------------------------------------------------------
; Mode Fix for A.I.

[State -2, VarSet]
type = VarSet
trigger1 = var(59) != 0
var(28) = 0

;----------------------------------------------------------------------
; Debug

[State -3, DisplayToClipBoard]
type = DisplayToClipBoard
trigger1 = 1
text = "EC = %d v4 = %d fv6 = %f 30500 = %d ES = %d"
params = sysvar(1),var(4),fvar(6),NumProjID(30500),Enemy,StateNo
ignorehitpause = 1
supermovetime = 9999
pausemovetime = 9999

